#include "get_changes_batch.h"

#include <crypta/cm/services/common/serializers/back_reference/record/back_reference_record_serializer.h>
#include <crypta/cm/services/common/serializers/id/string/id_string_serializer.h>
#include <crypta/cm/services/common/serializers/match/record/match_record_serializer.h>
#include <util/generic/algorithm.h>

NCrypta::NCm::TChangesBatch NCrypta::NCm::GetChangesBatch(const TDbState& dbState) {
    TChangesBatch result;

    Transform(
        dbState.GetMatches().DeleteBegin(),
        dbState.GetMatches().DeleteEnd(),
        std::back_inserter(result.KeysToDelete),
        &NIdSerializer::ToString
    );

    Transform(
        dbState.GetBackRefs().DeleteBegin(),
        dbState.GetBackRefs().DeleteEnd(),
        std::back_inserter(result.KeysToDelete),
        &NIdSerializer::ToString
    );

    Transform(
        dbState.GetMatches().UpdateBegin(),
        dbState.GetMatches().UpdateEnd(),
        std::back_inserter(result.RecordsToUpdate),
        &NMatchSerializer::ToRecord
    );

    Transform(
        dbState.GetBackRefs().UpdateBegin(),
        dbState.GetBackRefs().UpdateEnd(),
        std::back_inserter(result.RecordsToUpdate),
        &NBackReferenceSerializer::ToRecord
    );

    return result;
}
