from yt import yson


DATA = "data"
STATUS = "status"
TYPE = "type"
VALUE = "value"
UNIXTIME = "unixtime"


def get_schema():
    schema = [
        {"name": TYPE, "type": "string", "required": True},
        {"name": VALUE, "type": "string", "required": True},
        {"name": DATA, "type": "string", "required": True},
        {"name": STATUS, "type": "string", "required": True},
        {"name": UNIXTIME, "type": "int64", "required": True},
    ]
    schema = yson.YsonList(schema)
    schema.attributes["strict"] = True
    schema.attributes["unique_keys"] = False
    return schema
