import grpc
import requests

from crypta.cm.services.quoter.grpc import (
    quoter_service_pb2,
    quoter_service_pb2_grpc,
)


class QuoterClient(object):
    def __init__(self, host, port):
        self.host = host
        self.port = port

    def get_quota_state(self, environment_type):
        with grpc.insecure_channel("{}:{}".format(self.host, self.port)) as channel:
            stub = quoter_service_pb2_grpc.TQuoterServiceStub(channel)
            request = quoter_service_pb2.TGetQuotaRequest(EnvironmentType=environment_type)
            return stub.GetQuotaState(request)

    def ping(self):
        with grpc.insecure_channel("{}:{}".format(self.host, self.port)) as channel:
            stub = quoter_service_pb2_grpc.TQuoterServiceStub(channel)
            request = quoter_service_pb2.TPingRequest()
            return stub.Ping(request)


class QuoterHttpClient(object):
    class Exception(BaseException):
        def __init__(self, status_code, message):
            self.status_code = status_code
            self.message = message

    def __init__(self, host, port):
        self.host = host
        self.port = port
        self.base_url = "http://{}:{}".format(self.host, self.port)

    def _parse_response(self, response):
        if response.status_code != requests.codes.ok:
            raise QuoterHttpClient.Exception(response.status_code, response.text)

        return response.json()

    def get_quota_state(self, environment_type):
        return self._parse_response(requests.get("{}/get_quota_state/{}".format(self.base_url, environment_type)))

    def ping(self):
        return self._parse_response(requests.get("{}/ping".format(self.base_url)))
