#include "back_reference_proto_serializer.h"

using namespace NCrypta::NCm;

void NBackReferenceSerializer::ToProto(const TBackReference& backReference, TBackRefProto& proto) {
    proto.MutableId()->SetType(backReference.Id.Type);
    proto.MutableId()->SetValue(backReference.Id.Value);

    for (const auto& id : backReference.Refs) {
        auto* protoBackRefs = proto.AddRefs();
        protoBackRefs->SetType(id.Type);
        protoBackRefs->SetValue(id.Value);
    }
}

TBackRefProto NBackReferenceSerializer::ToProto(const TBackReference& backReference) {
    TBackRefProto proto;
    ToProto(backReference, proto);
    return proto;
}


void NBackReferenceSerializer::FromProto(const TBackRefProto& proto, TBackReference& backReference) {
    backReference.Id.Type = proto.GetId().GetType();
    backReference.Id.Value = proto.GetId().GetValue();

    backReference.Refs.reserve(proto.RefsSize());

    for (const auto& ref : proto.GetRefs()) {
        backReference.Refs.emplace(ref.GetType(), ref.GetValue());
    }
}

TBackReference NBackReferenceSerializer::FromProto(const TBackRefProto& proto) {
    TBackReference backReference;
    FromProto(proto, backReference);
    return backReference;
}
