#include "back_reference_record_serializer.h"

#include <crypta/cm/services/common/serializers/back_reference/proto/back_reference_proto_serializer.h>
#include <crypta/cm/services/common/serializers/back_reference_proto/record/back_reference_proto_record_serializer.h>

using namespace NCrypta::NCm;

NCrypta::TRecord NBackReferenceSerializer::ToRecord(const TBackReference& backReference) {
    const auto& proto = NBackReferenceSerializer::ToProto(backReference);
    return NBackReferenceProtoSerializer::ToRecord(proto);
}

TBackReference NBackReferenceSerializer::FromRecord(const NCrypta::TRecord& record) {
    const auto& proto = NBackReferenceProtoSerializer::FromRecord(record);
    return NBackReferenceSerializer::FromProto(proto);
}
