#include "back_reference_proto_record_serializer.h"

#include <crypta/cm/services/common/data/proto_helpers.h>
#include <crypta/cm/services/common/serializers/id/string/id_string_serializer.h>
#include <crypta/cm/services/common/serializers/id_proto/string/id_proto_string_serializer.h>
#include <crypta/lib/native/proto_serializer/proto_serializer.h>

#include <util/stream/str.h>
#include <util/stream/zlib.h>

using namespace NCrypta::NCm;

NCrypta::TRecord NBackReferenceProtoSerializer::ToRecord(const TBackRefProto& backReference) {
    NCrypta::TRecord record;
    ToRecord(backReference, record);
    return record;
}

void NBackReferenceProtoSerializer::ToRecord(const TBackRefProto& proto, NCrypta::TRecord& record) {
    record.Key = NIdProtoSerializer::ToString(proto.GetId());

    TBackRefProto protoWithNoId;
    *protoWithNoId.MutableRefs() = proto.GetRefs();

    const auto& serializedValue = protoWithNoId.SerializeAsString();

    TStringOutput stringOutput(record.Value);
    TZLibCompress compressor(&stringOutput);
    compressor.Write(serializedValue.c_str(), serializedValue.size());
}

TBackRefProto NBackReferenceProtoSerializer::FromRecord(const NCrypta::TRecord& record) {
    TBackRefProto proto;
    FromRecord(record, proto);
    return proto;
}

void NBackReferenceProtoSerializer::FromRecord(const NCrypta::TRecord& record, TBackRefProto& refs) {
    TStringInput stringInput(record.Value);
    TZDecompress decompressor(&stringInput);
    const auto& decompressedProtoStr = decompressor.ReadAll();

    NProtoSerializer::FromString(refs, decompressedProtoStr);

    TId id = NIdSerializer::FromString(record.Key);
    refs.MutableId()->SetType(id.Type);
    refs.MutableId()->SetValue(id.Value);
}
