#include "id_string_serializer.h"

#include <util/string/split.h>

using namespace NCrypta::NCm;

TString NIdSerializer::ToString(const TId& id) {
    return JoinId(id.Type, id.Value);
}

TId NIdSerializer::FromString(const TString& str) {
    TId id;
    SplitId(str, id.Type, id.Value);
    return id;
}

void NIdSerializer::SplitId(const TString& str, TString& type, TString& value) {
    Y_ENSURE(StringSplitter(str).Split(DELIMITER).Limit(2).TryCollectInto(&type, &value), "Could not split id '" << str << "' by delimiter '" << DELIMITER << "'");
}
