#pragma once

#include <crypta/cm/services/common/data/id.h>

#include <util/string/builder.h>

namespace NCrypta::NCm::NIdSerializer {
    static const char DELIMITER = ':';

    TString ToString(const TId& id);
    TId FromString(const TString& str);

    template <typename TValue>
    TString JoinId(const TString& type, const TValue& value) {
        return TStringBuilder() << type << DELIMITER << value;
    }

    void SplitId(const TString& str, TString& type, TString& value);
}
