#include "match_proto_serializer.h"

#include <crypta/lib/native/proto_serializer/proto_serializer.h>

using namespace NCrypta::NCm;

TString NMatchSerializer::ToProtoString(const TMatch& match) {
    return ToProto(match).SerializeAsString();
}

TMatchProto NMatchSerializer::ToProto(const TMatch& match) {
    TMatchProto proto;
    ToProto(match, proto);
    return proto;
}

void NMatchSerializer::ToProto(const TMatch& match, TMatchProto& proto) {
    proto.MutableExtId()->SetType(match.GetExtId().Type);
    proto.MutableExtId()->SetValue(match.GetExtId().Value);
    proto.SetTouch(match.GetTouch().Seconds());
    proto.SetTtl(match.GetTtl().Seconds());
    proto.SetTrackBackReference(match.GetTrackBackReference());

    auto* ids = proto.MutableMatchedIds()->MutableIds();
    for (const auto& [type, matchedId] : match.GetInternalIds()) {
        auto* idProto = ids->Add();
        auto* id = idProto->MutableId();
        id->SetType(type);
        id->SetValue(matchedId.GetId().Value);
        idProto->SetMatchTs(matchedId.GetMatchTs().Seconds());
        idProto->SetCas(matchedId.GetCas());
        SerializeAttributes(matchedId.GetAttributes(), *idProto->MutableAttributes());
    }
}

TMatch NMatchSerializer::FromProtoString(const TStringBuf& protoStr) {
    Y_ENSURE(!protoStr.empty(), "Serialized ext_id match is empty");
    return FromProto(NProtoSerializer::CreateFromString<TMatchProto>(protoStr));
}

TMatch NMatchSerializer::FromProto(const TMatchProto& proto) {
    TMatch match;
    FromProto(proto, match);
    return match;
}

void NMatchSerializer::FromProto(const TMatchProto& proto, TMatch& match) {
    match.Clear();

    match.SetExtId(TId(proto.GetExtId().GetType(), proto.GetExtId().GetValue()));
    match.SetTouch(TInstant::Seconds(proto.GetTouch()));
    match.SetTtl(TDuration::Seconds(proto.GetTtl()));
    match.SetTrackBackReference(proto.GetTrackBackReference());

    TMatch::TMatchedIds ids;
    for (const auto& idProto : proto.GetMatchedIds().GetIds()) {
        auto attrs = DeserializeAttributes(idProto.GetAttributes());
        match.AddId(TMatchedId{
            TId(idProto.GetId().GetType(), idProto.GetId().GetValue()),
            TInstant::Seconds(idProto.GetMatchTs()),
            idProto.GetCas(),
            attrs
        });
    }

    //TODO(r-andrey): check for empty values
}
