#include "match_record_serializer.h"

#include <crypta/cm/services/common/serializers/match/proto/match_proto_serializer.h>
#include <crypta/cm/services/common/serializers/match_proto/record/match_proto_record_serializer.h>

using namespace NCrypta::NCm;

NCrypta::TRecord NMatchSerializer::ToRecord(const TMatch& match) {
    return NMatchProtoSerializer::ToRecord(NMatchSerializer::ToProto(match));
}

TMatch NMatchSerializer::FromRecord(const NCrypta::TRecord& record) {
    const auto& proto = NMatchProtoSerializer::FromRecord(record);
    return NMatchSerializer::FromProto(proto);
}
