#include "match_proto_record_serializer.h"

#include <crypta/cm/services/common/data/proto_helpers.h>
#include <crypta/cm/services/common/serializers/id_proto/string/id_proto_string_serializer.h>
#include <crypta/lib/native/proto_serializer/proto_serializer.h>

#include <util/string/cast.h>
#include <util/stream/zlib.h>

using namespace NCrypta::NCm;

NCrypta::TRecord NMatchProtoSerializer::ToRecord(TMatchProto&& proto) {
    TRecord record;
    ToRecord(std::move(proto), record);
    return record;
}

void NMatchProtoSerializer::ToRecord(TMatchProto&& proto, NCrypta::TRecord& record) {
    record.Key = NIdProtoSerializer::ToString(proto.GetExtId());

    proto.ClearExtId();

    const auto& serializedValue = proto.SerializeAsString();

    TStringOutput stringOutput(record.Value);
    TZLibCompress compressor(&stringOutput);
    compressor.Write(serializedValue.c_str(), serializedValue.size());
}

TMatchProto NMatchProtoSerializer::FromRecord(const NCrypta::TRecord& record) {
    TMatchProto proto;
    FromRecord(record, proto);
    return proto;
}

void NMatchProtoSerializer::FromRecord(const NCrypta::TRecord& record, TMatchProto& proto) {
    TStringInput stringInput(record.Value);
    TZDecompress decompressor(&stringInput);
    const auto& decompressedProtoStr = decompressor.ReadAll();

    NProtoSerializer::FromString(proto, decompressedProtoStr);

    auto key = NIdProtoSerializer::FromString(record.Key);
    proto.MutableExtId()->Swap(&key);
}
