import argparse
import logging

from crypta.cm.services.db_backup.lib import db_backup
from crypta.cm.services.db_backup.lib.config_pb2 import TConfig
from crypta.lib.python import yaml_config
from crypta.lib.python.logging import logging_helpers


logger = logging.getLogger(__name__)


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--config", required=True)
    return parser.parse_args()


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())

    args = parse_args()
    config = yaml_config.parse_config(TConfig, args.config)
    logger.info(config)

    db_backup.run(config)
