import datetime
import os

import yt.wrapper as yt

from crypta.lib.python import time_utils
from crypta.lib.python.yt import (
    tm_utils,
    yt_helpers,
)
from crypta.lib.python.yt.dyntable_utils import (
    dump,
    replica_utils,
)


def _create_dir(yt_client, dir):
    yt_client.create("map_node", dir, recursive=True, ignore_existing=True)


def _get_min_replication_timestamp(master_client, master_table, replica_cluster, replica_table):
    replica_id = replica_utils.get_replica_id_by_path(master_client, master_table, replica_cluster, replica_table)

    return min(
        tablet["current_replication_timestamp"]
        for tablet in master_client.get("#{}/@tablets".format(replica_id))
    )


def run(config):
    master_client = yt_helpers.get_yt_client(config.MasterCluster)

    src_client = yt_helpers.get_yt_client(config.SrcCluster)
    src_cluster_name = yt_helpers.get_cluster_name(src_client)
    src_table = config.SrcTable
    src_tmp_dir = config.SrcTmpDir
    _create_dir(src_client, src_tmp_dir)

    dst_client = yt_helpers.get_yt_client(config.DstCluster)
    dst_dir = config.DstDir
    _create_dir(dst_client, dst_dir)
    dst_table = yt.ypath_join(dst_dir, str(time_utils.get_current_time()))

    tm_client = tm_utils.get_client(os.environ.get("YT_TOKEN"))

    with src_client.TempTable(src_tmp_dir) as dump_path:
        min_replication_timestamp = _get_min_replication_timestamp(master_client, config.MasterTable, src_cluster_name, src_table)
        dump.dump_table(src_client, src_table, dump_path, config.SrcPool, timestamp=min_replication_timestamp)

        force = True
        tm_utils.move_or_transfer_table(src_client, dump_path, dst_client, dst_table, force, tm_client)

        yt_helpers.set_ttl(dst_table, datetime.timedelta(days=config.BackupTtlDays), dst_client)
