from crypta.lib.python import duid_upload

from yt import yson


DATA = "data"
STATUS = "status"
FPC = duid_upload.FPC_FIELD
DUID = duid_upload.DUID_FIELD
YUID = duid_upload.YANDEXUID_FIELD
UNIXTIME = "unixtime"


def get_errors_schema():
    schema = [
        {"name": DATA, "type": "string", "required": False},
        {"name": YUID, "type": "string", "required": False},
        {"name": DUID, "type": "string", "required": False},
        {"name": STATUS, "type": "string", "required": False},
        {"name": UNIXTIME, "type": "uint64", "required": False},
    ]
    schema = yson.YsonList(schema)
    schema.attributes["strict"] = True
    schema.attributes["unique_keys"] = False
    return schema
