EXECTEST()

OWNER(
    g:crypta
    g:crypta-cm
)

RUN(
    NAME testing_config
    CWD ${ARCADIA_ROOT}/crypta/cm/services/mutator/bundle/templates

    render_and_check_yaml
        --template config.yaml
        --output ${TEST_CASE_ROOT}/output.yaml
        --context '{"environment": "testing", "installation": "russia", "dc": "man", "fqdn": "localhost"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME stable_config
    CWD ${ARCADIA_ROOT}/crypta/cm/services/mutator/bundle/templates

    render_and_check_yaml
        --template config.yaml
        --output ${TEST_CASE_ROOT}/output.yaml
        --context '{"environment": "production", "installation": "russia", "dc": "sas", "fqdn": "localhost"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME stable_config_international
    CWD ${ARCADIA_ROOT}/crypta/cm/services/mutator/bundle/templates

    render_and_check_yaml
        --template config.yaml
        --output ${TEST_CASE_ROOT}/output.yaml
        --context '{"environment": "production", "installation": "international", "dc": "azuseast1", "fqdn": "localhost"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME testing_qa
    CWD ${ARCADIA_ROOT}/crypta/cm/services/mutator/bundle/templates

    render_and_check_yaml
        --template config.yaml
        --output ${TEST_CASE_ROOT}/output.yaml
         --context '{"environment": "qa", "installation": "mother-russia", "dc": "qa", "change_log_server": "localhost", "change_log_port": "20500", "change_log_topic": "change-log", "evacuate_log_server": "localhost", "evacuate_log_port": "20500", "evacuate_log_topic": "evacuate-log", "client_id": "lb-consumer", "client_tvm_id": "", "master_table_path": "//master/table/path", "yt_proxy_url": "master.yt.yandex.net", "proxy_role": "default", "default_ttl": 100000, "extended_ttl": 300000, "custom_ttls": [["foo", 3600],["bar", 1800]], "log_dir": "/tmp", "use_secure_tvm": false, "log_level": "trace", "tracked_back_references": ["foo"], "fqdn": "localhost"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

DATA(
    arcadia/crypta/cm/services/mutator/bundle/templates/config.yaml
)

DEPENDS(
    crypta/utils/render_and_check_yaml
)

END()
