#include "handler_factory.h"

#include <crypta/cm/services/common/changes/change_commands.h>
#include <crypta/cm/services/common/changes/change_log_fields.h>
#include <crypta/cm/services/common/changes/delete_command.h>
#include <crypta/cm/services/common/changes/expire_command.h>
#include <crypta/cm/services/common/serializers/id/string/id_string_serializer.h>
#include <crypta/cm/services/mutator/lib/handlers/delete_handler.h>
#include <crypta/cm/services/mutator/lib/handlers/expire_handler.h>
#include <crypta/cm/services/mutator/lib/handlers/touch_handler.h>
#include <crypta/cm/services/mutator/lib/handlers/upload_handler.h>

using namespace NCrypta::NCm::NMutator;

THandlerFactory::THandlerFactory(const THashSet<TString>& trackedBackRefTags, const TTtlConfig& ttlConfig, NPQ::TProducer& evacuateLogProducer, TStats& stats)
        : TrackedBackRefTags(trackedBackRefTags)
        , TtlConfig(ttlConfig)
        , EvacuateLogProducer(evacuateLogProducer)
        , Stats(stats)
{
}

THandlerPtr THandlerFactory::CreateHandler(const TStringBuf& str) const {
    const auto& commandJson = NChangeCommands::ParseToJsonValue(str);
    const auto& cmd = commandJson[NChangeLogFields::CMD].GetString();
    const auto& commandTimestamp = TInstant::Seconds(commandJson[NChangeLogFields::UNIXTIME].GetInteger());

    if (cmd == NChangeCommands::DELETE) {
        return MakeHolder<TDeleteHandler>(commandTimestamp, TDeleteCommand::FromJsonValue(commandJson), Stats);
    } else if (cmd == NChangeCommands::EXPIRE) {
        return MakeHolder<TExpireHandler>(commandTimestamp, TExpireCommand::FromJsonValue(commandJson), Stats);
    } else if (cmd == NChangeCommands::UPLOAD) {
        return MakeHolder<TUploadHandler>(commandTimestamp, TUploadCommand::FromJsonValue(commandJson), TrackedBackRefTags, TtlConfig, EvacuateLogProducer, Stats);
    } else if (cmd == NChangeCommands::TOUCH) {
        return MakeHolder<TTouchHandler>(commandTimestamp, TTouchCommand::FromJsonValue(commandJson), TtlConfig, Stats);
    } else {
        ythrow yexception() << "Unknown command type: " << cmd;
    }
}
