#pragma once

#include <crypta/cm/services/mutator/lib/config/ttl_config.pb.h>
#include <crypta/cm/services/mutator/lib/handlers/handler.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/pqlib/producer.h>

#include <util/generic/ptr.h>

namespace NCrypta::NCm::NMutator {
    class THandlerFactory {
    public:
        THandlerFactory(const THashSet<TString>& trackedBackRefTags, const TTtlConfig& ttlConfig, NPQ::TProducer& evacuateLogProducer, TStats& stats);

        THandlerPtr CreateHandler(const TStringBuf& str) const;

    private:
        const THashSet<TString>& TrackedBackRefTags;
        const TTtlConfig& TtlConfig;
        NPQ::TProducer& EvacuateLogProducer;
        TStats& Stats;
    };
}
