#include "delete_handler.h"

#include <crypta/cm/services/common/db_state/db_state_loader.h>
#include <crypta/lib/native/time/shifted_clock.h>

#include <util/datetime/base.h>

using namespace NCrypta::NCm;
using namespace NCrypta::NCm::NMutator;

TDeleteHandler::TDeleteHandler(TInstant commandTimestamp, TExtIdCommand deleteCommand, TStats& stats)
    : THandler(commandTimestamp, stats, "delete")
    , DeleteCommand(std::move(deleteCommand))
{
}

TString TDeleteHandler::GetShardingKey() const {
    return DeleteCommand.ShardingKey;
}

TVector<TId> TDeleteHandler::GetLookupIds() {
    return { DeleteCommand.ExtId };
}

void TDeleteHandler::UpdateDbState(TDbState& dbState) {
    const auto* match = dbState.GetMatches().Get(DeleteCommand.ExtId);

    if (!match) {
        return;
    }

    dbState.DeleteMatch(DeleteCommand.ExtId);
    Deleted = true;
}

void TDeleteHandler::OnCommitSuccess() {
    Stats.Count->Add("delete.total");
    Stats.Count->Add(Deleted ? "delete.deleted" : "delete.skipped");
}
