#pragma once

#include "handler.h"

#include <crypta/cm/services/common/changes/ext_id_command.h>

#include <util/generic/hash.h>

namespace NCrypta::NCm::NMutator {
    class TDeleteHandler : public THandler {
    public:
        TDeleteHandler(TInstant commandTimestamp, TExtIdCommand deleteCommand, TStats& stats);

        TString GetShardingKey() const override;

        TVector<NCm::TId> GetLookupIds() override;
        void UpdateDbState(NCm::TDbState& dbState) override;

    private:
        void OnCommitSuccess() override;

        const TExtIdCommand DeleteCommand;
        bool Deleted = false;
    };
}
