#include "expire_handler.h"

#include <crypta/cm/services/common/db_state/db_state_loader.h>
#include <crypta/cm/services/common/expiration/is_expired.h>
#include <crypta/lib/native/time/shifted_clock.h>

#include <util/datetime/base.h>

using namespace NCrypta::NCm;
using namespace NCrypta::NCm::NMutator;

TExpireHandler::TExpireHandler(TInstant commandTimestamp, TExtIdCommand expireCommand, TStats& stats)
    : THandler(commandTimestamp, stats, "expire")
    , ExpireCommand(std::move(expireCommand))
{
}

TString TExpireHandler::GetShardingKey() const {
    return ExpireCommand.ShardingKey;
}

TVector<TId> TExpireHandler::GetLookupIds() {
    return { ExpireCommand.ExtId };
}

void TExpireHandler::UpdateDbState(TDbState& dbState) {
    const auto* match = dbState.GetMatches().Get(ExpireCommand.ExtId);

    if (!match || !IsExpired(*match, TShiftedClock::Now())) {
        return;
    }

    dbState.DeleteMatch(ExpireCommand.ExtId);
    Expired = true;
}

void TExpireHandler::OnCommitSuccess() {
    Stats.Count->Add("expire.total");
    Stats.Count->Add(Expired ? "expire.expired" : "expire.skipped");
}
