#pragma once

#include "handler.h"

#include <crypta/cm/services/common/changes/ext_id_command.h>

#include <util/generic/hash.h>

namespace NCrypta::NCm::NMutator {
    class TExpireHandler : public THandler {
    public:
        TExpireHandler(TInstant commandTimestamp, TExtIdCommand expireCommand, TStats& stats);

        TString GetShardingKey() const override;

        TVector<NCm::TId> GetLookupIds() override;
        void UpdateDbState(NCm::TDbState& dbState) override;

    private:
        void OnCommitSuccess() override;

        const TExtIdCommand ExpireCommand;
        bool Expired = false;
    };
}
