#include "handler.h"

using namespace NCrypta::NCm::NMutator;

THandler::THandler(TInstant commandTimestamp, TStats& stats, const TString& logName)
    : Stats(stats)
    , Log(NCrypta::NLog::GetLog(logName))
    , CommandTimestamp(commandTimestamp)
    , CommitPromise(NYT::NewPromise<void>())
{
}

NYT::TFuture<void> THandler::GetCommitFuture() const {
    return CommitPromise.ToFuture();
}

void THandler::CommitSuccess() {
    Stats.Percentile->Add("command.latency", (TInstant::Now() - CommandTimestamp).Seconds());

    OnCommitSuccess();

    CommitPromise.Set();
}

TMaybe<TString> THandler::GetDeduplicationKey() const {
    return Nothing();
}
