#pragma once

#include "handler.h"
#include "ttl_selector.h"

#include <crypta/cm/services/common/changes/touch_command.h>
#include <crypta/cm/services/mutator/lib/config/ttl_config.pb.h>

#include <util/generic/maybe.h>
#include <util/generic/vector.h>

namespace NCrypta::NCm::NMutator {
    class TTouchHandler : public THandler {
    public:
        TTouchHandler(
            TInstant commandTimestamp,
            TTouchCommand touchCommand,
            const TTtlConfig& ttlConfig,
            TStats& stats);

        TString GetShardingKey() const override;
        TMaybe<TString> GetDeduplicationKey() const override;

        TVector<TId> GetLookupIds() override;
        void UpdateDbState(TDbState& dbState) override;

    private:
        TMaybe<TDuration> SelectTtl(TInstant oldTouch, TInstant newTouch, const TString& extIdType) const;
        void OnCommitSuccess() override;

        const TTouchCommand TouchCommand;
        const TTtlSelector TtlSelector;
    };
}
