#pragma once

#include <crypta/cm/services/common/data/match.h>
#include <crypta/cm/services/mutator/lib/config/ttl_config.pb.h>

#include <util/datetime/base.h>
#include <util/generic/string.h>

namespace NCrypta::NCm::NMutator {
    class TTtlSelector {
    public:
        explicit TTtlSelector(const TTtlConfig& ttlConfig);

        TDuration GetDefaultTtl(const TString& extIdType) const;
        TDuration GetExtendedTtl(const TString& extIdType) const;

        bool SetAppropriateTtl(TMatch& incomingMatch, const TMatch* dbMatch) const;
        bool IsTouchTimeoutElapsed(TInstant oldTouchTime, TInstant newTouchTime) const;
        bool IsExtendTtlTimeoutElapsed(TInstant oldTouchTime, TInstant newTouchTime) const;

    private:
        const TTtlConfig& TtlConfig;
    };
}
