#pragma once

#include "handler.h"
#include "ttl_selector.h"

#include <crypta/cm/services/common/changes/upload_command.h>
#include <crypta/cm/services/common/db_state/db_state.h>
#include <crypta/cm/services/mutator/lib/config/ttl_config.pb.h>

#include <crypta/lib/native/pqlib/producer.h>

namespace NCrypta::NCm::NMutator {
    class TUploadHandler : public THandler {
    public:
        TUploadHandler(
                TInstant commandTimestamp,
                TUploadCommand uploadCommand,
                const THashSet<TString>& trackedBackRefTags,
                const TTtlConfig& ttlConfig,
                NPQ::IProducer& evacuateLogProducer,
                TStats& stats);

        TString GetShardingKey() const override;

        TVector<NCm::TId> GetLookupIds() override;
        void UpdateDbState(TDbState& dbState) override;

    private:
        void OnCommitSuccess() override;

        void WriteEvacuateLog();

        const TUploadCommand UploadCommand;
        const THashSet<TString>& TrackedBackRefTags;
        const TTtlSelector TtlSelector;
        NPQ::IProducer& EvacuateLogProducer;
    };
}
