#pragma once

#include <crypta/cm/services/mutator/lib/handler_queue.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/yt/dyntables/async_database/kv_database.h>

#include <library/cpp/cache/cache.h>
#include <library/cpp/retry/retry.h>

#include <util/generic/deque.h>

namespace NCrypta::NCm::NMutator {
    class TProcessor : public NYT::TRefCounted {
    public:
        TProcessor(
                THandlerQueue& handlerQueue,
                NYtDynTables::TKvDatabase& database,
                size_t maxCommandsPerTransaction,
                TRetryOptions commitRetryOptions,
                TDuration maxBatchingTime,
                const THashSet<TString>& trackedBackRefTags,
                ui64 deduplicationCacheSize,
                TDuration cacheMaxAge,
                TStats& stats
         );

        void Run();
    private:
        struct TBatch {
            THandlers Handlers;
            ui64 Retries = 0;
            ui64 WriteCount = 0;
            ui64 DeleteCount = 0;
            TInstant NextTry;

            bool operator>(const TBatch& other) const;
        };
        using TIds = TVector<TId>;

        struct THandlerWeighter {
            static TInstant Weight(const TInstant& commandTimestamp);
        };

        using TCache = TLWCache<TString, TInstant, TInstant, THandlerWeighter>;

        TBatch GetBatch();

        TIds GetLookupIds(TBatch& handlers);
        bool ApplyChanges(const TIds& lookupIds, TBatch& handlers);
        void CommitSuccess(TBatch& handlers);

        THandlerQueue& HandlerQueue;
        TDeque<THandlerPtr> DequeuedHandlers;
        TInstant LastDequeueTime;
        TDuration CacheMaxAge;
        TCache HandlerCache;

        NYtDynTables::TKvDatabase& Database;
        const size_t MaxCommandsPerTransaction = 0;
        const TDuration MaxBatchingTime;
        const TRetryOptions CommitRetryOptions;
        const THashSet<TString>& TrackedBackRefTags;

        TVector<TBatch> Batches;

        NLog::TLogPtr Log;
        TStats& Stats;
    };
}
