#include "get_ext_id_mapper.h"

#include "error_fields.h"
#include "fields.h"

#include <util/digest/fnv.h>
#include <util/string/cast.h>

using namespace NCrypta;
using namespace NCrypta::NCm::NPrepareSync;

TGetExtIdMapper::TGetExtIdMapper(const TOutputIndexes& outputIndexes,
                                 const TRestSampler& sampler)
    : OutputIndexes(outputIndexes)
    , Sampler(sampler)
{
}

bool TGetExtIdMapper::NeedIdentify(const NIscryptaLogParser::TIdentifyInfo& identifyInfo) const {
    return Sampler.Passes(identifyInfo.Timestamp);
}

void TGetExtIdMapper::Process(const NYT::TNode& row, TWriter* writer) const {
    if (NIscryptaLogParser::HasExtIdIdentifyRequest(row)) {
        const auto& identifyInfo = NIscryptaLogParser::ParseIdentifyInfo(row);

        if (NeedIdentify(identifyInfo)) {
            writer->AddRow(
                NYT::TNode()
                    (NFields::TAG, identifyInfo.ExtId.Tag)
                    (NFields::EXT_ID, identifyInfo.ExtId.Value),
                *OutputIndexes[EOutputTables::ToIdentify]
            );
        }
    }
}

void TGetExtIdMapper::Do(TReader* reader, TWriter* writer) {

    for (; reader->IsValid(); reader->Next()) {
        const auto& row = reader->GetRow();

        try {
            Process(row, writer);
        } catch (const yexception& e) {
            writer->AddRow(
                NYT::TNode()
                    (NDbErrorFields::ROW, row)
                    (NDbErrorFields::WHAT, e.what()),
                *OutputIndexes[EOutputTables::Errors]
            );
        }
    }
}

REGISTER_MAPPER(TGetExtIdMapper);
