#pragma once

#include <crypta/lib/native/iscrypta_log_parser/iscrypta_log_parser.h>
#include <crypta/lib/native/sampler/hash_sampler.h>
#include <crypta/lib/native/sampler/rest_sampler.h>
#include <crypta/lib/native/yt/utils/tables_indexes.h>

#include <mapreduce/yt/interface/client.h>

#include <util/generic/hash.h>
#include <util/generic/hash_set.h>
#include <util/generic/maybe.h>
#include <util/generic/string.h>

namespace NCrypta::NCm::NPrepareSync {
    class TGetExtIdMapper : public NYT::IMapper<NYT::TNodeReader, NYT::TNodeWriter> {
    private:
        static ui64 ExtIdHash(const TStringBuf& buf);

    public:
        enum class EOutputTables {
            ToIdentify,
            Errors
        };

        using TOutputIndexes = TTablesIndexes<EOutputTables>;

        TGetExtIdMapper() = default;
        TGetExtIdMapper(const TOutputIndexes& outputIndexes,
                        const TRestSampler& sampler);

        void Do(TReader* reader, TWriter* writer) override;

        Y_SAVELOAD_JOB(OutputIndexes, Sampler);

    private:
        bool NeedIdentify(const NIscryptaLogParser::TIdentifyInfo& identifyInfo) const;
        void Process(const NYT::TNode& row, TWriter* writer) const;

        TOutputIndexes OutputIndexes;
        TRestSampler Sampler = TRestSampler(1, 0, TRestSampler::EMode::Equal);
    };
}
