import yt.wrapper as yt

from crypta.lib.python.yql import yql_helpers
from crypta.lib.python.yt import (
    path_utils,
    yt_helpers,
)
from crypta.lib.python.yt.processed_tables_tracker import ProcessedTablesTracker


def run(config, logger):
    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)
    tracker = ProcessedTablesTracker(config.CmAccessLog)

    def prepare_table(tx, input_table):
        output_table = yt.ypath_join(config.OutputDir, path_utils.get_basename(input_table))

        params = {
            "input_table": input_table,
            "output_table": output_table,
        }
        yql_helpers.run_query("/query/prepare_touch_table.yql", config.Yt, params, logger, tx=tx)

    tracker.for_each_unprocessed(yt_client, prepare_table)
