#include <crypta/cm/services/quoter/bin/quoter/lib/config/config.pb.h>
#include <crypta/cm/services/quoter/bin/quoter/lib/quoter_server/quoter_server.h>
#include <crypta/cm/services/quoter/bin/quoter/lib/state/quoter_state.h>
#include <crypta/cm/services/quoter/bin/quoter/lib/state/quoter_state_updater.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/signal_waiter/signal_waiter.h>
#include <crypta/lib/native/stats/log/log_stats_sink.h>
#include <crypta/lib/native/stats/solomon/solomon_stats_sink.h>
#include <crypta/lib/native/stats/stats_writer.h>
#include <crypta/lib/native/stats/utils.h>
#include <crypta/lib/native/yaml/config/config.h>

#include <grpc++/server.h>
#include <grpc++/server_builder.h>
#include <grpc/grpc.h>

#include <util/generic/vector.h>
#include <util/string/cast.h>

using namespace NCrypta;
using namespace NCrypta::NCm::NQuoter;

int main(int argc, const char** argv) {
    TSignalWaiter stopSignalWaiter({SIGTERM, SIGINT});

    const auto& config = ParseYamlConfig<TConfig>(argc, argv);

    NCrypta::NLog::RegisterLogs(config.GetLogs());
    auto log = NLog::GetLog("main");

    TVector<THolder<IStatsSink>> sinks;
    sinks.emplace_back(MakeHolder<TSolomonStatsSink>(config.GetSolomon()));

    auto statsWriter = GetStatsWriter(std::move(sinks));

    const auto& statsSettings = GetStatsSettings(config.GetStats());

    TQuoterState quoterState;
    TQuoterStateUpdater quoterStateUpdater(
        quoterState,
        TDuration::Seconds(config.GetUpdateIntervalSec()),
        config.GetSolomon(),
        TDuration::Seconds(config.GetSolomonDataRequestTimeoutSec()),
        config.GetDyntablesPolicy(),
        statsSettings);

    TQuoterServer server(config.GetPort(), quoterState, statsSettings);

    log->info("Starting quoter server...");
    server.Start();
    log->info("Started");

    stopSignalWaiter.Wait();
    log->info("Shutting down");
    return 0;
}
