#pragma once

#include <crypta/cm/services/quoter/bin/quoter/lib/state/quoter_state.h>
#include <crypta/cm/services/quoter/grpc/quoter_service.grpc.pb.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/stats/stats.h>

#include <contrib/libs/grpc/include/grpc++/server.h>
#include <contrib/libs/grpc/include/grpc++/server_builder.h>

#include <util/generic/ptr.h>

namespace NCrypta::NCm::NQuoter {
    class TQuoterServer {
    public:
        TQuoterServer(ui32 port, const TQuoterState& quoterState, const TStats::TSettings& statsSettings);
        ~TQuoterServer();

        void Start();

    private:
        const ui32 Port;
        THolder<TQuoterService::Service> Service;
        std::unique_ptr<grpc::Server> Server;
        NLog::TLogPtr Log;
        const TStats::TSettings& StatsSettings;
    };
}
