#include "quoter_service_impl.h"

#include <crypta/lib/native/time/scope_timer.h>

using namespace NCrypta::NCm::NQuoter;


TQuoterServiceImpl::TQuoterServiceImpl(const TQuoterState& quoterState, const TStats::TSettings& statsSettings)
    : QuoterState(quoterState)
    , Log(NLog::GetLog("quoter_server"))
    , Stats(TaggedSingleton<TStats, decltype(*this)>("quoter_server", statsSettings))
{
}

grpc::Status TQuoterServiceImpl::GetQuotaState(grpc::ServerContext*, const TGetQuotaRequest* request, TQuotaState* response) {
    TScopeTimer scopeTimer(Stats.Percentile, "timing.get_quota_state");

    Stats.Count->Add("request.get_quota_state.total.received");

    auto state = QuoterState.Get(request->GetEnvironmentType());

    if (state.Defined()) {
        Stats.Count->Add("request.get_quota_state.status.ok");
        response->Swap(state.Get());
        return grpc::Status::OK;
    } else {
        Stats.Count->Add("request.get_quota_state.status.error");
        return grpc::Status(grpc::StatusCode::NOT_FOUND, std::string("Environment type not found: ") + request->GetEnvironmentType());
    }
}

grpc::Status TQuoterServiceImpl::Ping(grpc::ServerContext*, const TPingRequest*, TPingResponse* response) {
    TScopeTimer scopeTimer(Stats.Percentile, "timing.ping");

    Stats.Count->Add("request.ping.status.ok");
    response->SetMessage("OK");
    return grpc::Status::OK;
}
