#pragma once

#include <crypta/cm/services/quoter/bin/quoter/lib/state/quoter_state.h>
#include <crypta/cm/services/quoter/grpc/quoter_service.grpc.pb.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/stats/stats.h>

namespace NCrypta::NCm::NQuoter {
    class TQuoterServiceImpl: public TQuoterService::Service {
    public:
        explicit TQuoterServiceImpl(const TQuoterState& quoterState, const TStats::TSettings& statsSettings);

    private:
        grpc::Status GetQuotaState(grpc::ServerContext* context, const TGetQuotaRequest* request, TQuotaState* response) override;
        grpc::Status Ping(grpc::ServerContext* context, const TPingRequest* request, TPingResponse* response) override;

        const TQuoterState& QuoterState;
        NLog::TLogPtr Log;
        TStats& Stats;
    };
}
