#include "quoter_state.h"

using namespace NCrypta::NCm::NQuoter;

TMaybe<TQuotaState> TQuoterState::Get(const TString& environmentType) const {
    TReadGuardBase<TLightRWLock> guard(StateLock);

    TMaybe<TQuotaState> result;
    if (State.contains(environmentType)) {
        result = State.at(environmentType);
    }
    return result;
}

void TQuoterState::Set(const TString& environmentType, const TQuotaState& state) {
    TWriteGuardBase<TLightRWLock> guard(StateLock);

    State[environmentType] = state;
}
