#pragma once

#include <crypta/cm/services/quoter/grpc/quoter_service.pb.h>

#include <library/cpp/threading/light_rw_lock/lightrwlock.h>

#include <util/generic/hash.h>
#include <util/generic/maybe.h>

namespace NCrypta::NCm::NQuoter {
    class TQuoterState {
    public:
        TQuoterState() = default;

        TMaybe<TQuotaState> Get(const TString& environmentType) const;
        void Set(const TString& environmentType, const TQuotaState& state);

    private:
        TLightRWLock StateLock;
        THashMap<TString, TQuotaState> State;
    };
}
