#pragma once

#include "quoter_state.h"

#include <crypta/cm/services/quoter/bin/quoter/lib/config/dyntables_policy.pb.h>
#include <crypta/cm/services/quoter/grpc/quoter_service.pb.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/periodic_task/periodic_task.h>
#include <crypta/lib/native/stats/solomon/proto/solomon_config.pb.h>
#include <crypta/lib/native/solomon/solomon_data_client.h>
#include <crypta/lib/native/stats/stats.h>

namespace NCrypta::NCm::NQuoter {
    class TQuoterStateUpdater: public TPeriodicTask {
    public:
        TQuoterStateUpdater(TQuoterState& quoterState,
                            const TDuration updateInterval,
                            const TSolomonConfig& solomonConfig,
                            const TDuration solomonRequestTimeout,
                            const TDyntablesPolicy& dyntablesPolicy,
                            const TStats::TSettings& statsSettings);

    private:
        using TProtoStringMap = google::protobuf::Map<TString, TString>;

        void UpdateState();
        double GetSolomonMetric(const TProtoStringMap& baseLabels, const TString& sensor) const;

        TQuoterState& QuoterState;
        TSolomonDataClient SolomonDataClient;
        const TDyntablesPolicy DyntablesPolicy;
        NLog::TLogPtr Log;
        TStats& Stats;
    };
}
