EXECTEST()

OWNER(
    g:crypta
    g:crypta-cm
)

RUN(
    NAME production
    CWD ${ARCADIA_ROOT}/crypta/cm/services/quoter/bundle/templates

    render_and_check_yaml
        --template config.yaml
        --output ${TEST_CASE_ROOT}/output.yaml
        --context '{"environment_type": "production", "installation": "russia"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME production_international
    CWD ${ARCADIA_ROOT}/crypta/cm/services/quoter/bundle/templates

    render_and_check_yaml
        --template config.yaml
        --output ${TEST_CASE_ROOT}/output.yaml
        --context '{"environment_type": "production", "installation": "international"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME testing
    CWD ${ARCADIA_ROOT}/crypta/cm/services/quoter/bundle/templates

    render_and_check_yaml
        --template config.yaml
        --output ${TEST_CASE_ROOT}/output.yaml
        --context '{"environment_type": "testing", "installation": "russia"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME qa
    CWD ${ARCADIA_ROOT}/crypta/cm/services/quoter/bundle/templates

    render_and_check_yaml
        --template config.yaml
        --output ${TEST_CASE_ROOT}/output.yaml
        --context '{"environment_type": "qa", "installation": "mother-russia", "logs_dir": "/tmp", "port": 1234, "solomon_schema": "http", "solomon_host": "localhost", "solomon_port": 2345}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME proxy_production
    CWD ${ARCADIA_ROOT}/crypta/cm/services/quoter/bundle/templates

    render_and_check_yaml
        --template http_proxy_config.yaml
        --output ${TEST_CASE_ROOT}/output.yaml
        --context '{"environment_type": "production"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME proxy_qa
    CWD ${ARCADIA_ROOT}/crypta/cm/services/quoter/bundle/templates

    render_and_check_yaml
        --template http_proxy_config.yaml
        --output ${TEST_CASE_ROOT}/output.yaml
        --context '{"environment_type": "qa", "port": 1234, "quoter_port": 2345}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

DATA(
    arcadia/crypta/cm/services/quoter/bundle/templates/config.yaml
    arcadia/crypta/cm/services/quoter/bundle/templates/http_proxy_config.yaml
)

DEPENDS(
    crypta/utils/render_and_check_yaml
)

END()
