#include <crypta/cm/services/rt_duid_uploader/common/lib/experiment_checker/experiment_checker.h>
#include <util/digest/murmur.h>

namespace NCrypta::NCm::NRtDuidUploader::NExperimentChecker {
    // https://a.yandex-team.ru/arc/trunk/arcadia/crypta/graph/fpc/lib/get_fpc_via_extfp.sql?rev=r8531247#L9
    bool ShouldUploadYandexuid(TStringBuf yuid) {
        const static TString defaultExperimentSalt{"extfp"};

        auto valueToHash = defaultExperimentSalt + TString{yuid};
        auto hashValue = MurmurHash<ui64>(valueToHash.data(), valueToHash.size());

        return hashValue % 2 == 0;
    }
}
