#pragma once

#include "duid_hash.h"
#include "uploader.h"

#include <crypta/cm/services/rt_duid_uploader/common/lib/config/parser_config.pb.h>
#include <crypta/lib/native/pqlib/cookie_queue.h>
#include <crypta/lib/native/sampler/hash_sampler.h>

#include <util/generic/vector.h>


namespace NCrypta::NCm::NRtDuidUploader {
    class TParser {
    public:
        TParser(const TParserConfig& config, TUploader& uploader, NPQ::TCookieQueue& cookiesToCommit, TStats& stats);

        void ScheduleParse(NPQ::TConsumer::TReadResult&& readResult);

        // temporary - CRYPTA-15205
        using TBannedYuids = THashSet<ui64>;

    private:
        void Parse(NPQ::TConsumer::TReadResult&& readResult);

        NYT::NConcurrency::TThreadPoolPtr ThreadPool;
        THashSampler<DuidHash> Sampler;
        TUploader& Uploader;
        NPQ::TCookieQueue& CookiesToCommit;
        const THashSet<TString> BannedSources;
        const THashSet<TString> ExperimentSources;

        NLog::TLogPtr Log;
        TStats& Stats;

        TBannedYuids BannedYuids;
    };
}
