#pragma once

#include "match.h"
#include "request_factory.h"

#include <crypta/cm/services/rt_duid_uploader/common/lib/config/uploader_config.pb.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/neh_sync_multi_client/neh_sync_multi_client.h>
#include <crypta/lib/native/stats/stats.h>

#include <library/cpp/neh/neh.h>
#include <yt/yt/core/concurrency/thread_pool.h>
#include <yt/yt/core/concurrency/throughput_throttler.h>

#include <util/generic/deque.h>
#include <util/system/sem.h>

namespace NCrypta::NCm::NRtDuidUploader {
    class TUploader : public NYT::TRefCounted {
    public:
        TUploader(
            const TUploaderConfig& config,
            const IRequestFactory& requestFactory,
            TStats& stats
         );

        NYT::TFuture<void> Upload(TMatch match);
    private:
        void AsyncUpload(TMatch match, TGuard<TFastSemaphore> guard);
        bool TryUpload(const NNeh::TMessage& message);

        TFastSemaphore InFlightSemaphore;
        NYT::NConcurrency::IThroughputThrottlerPtr Throttler;
        const TDuration RequestTimeout;
        const TDuration RetryTimeout;
        NYT::NConcurrency::TThreadPoolPtr ThreadPool;

        const IRequestFactory& RequestFactory;

        const TNehSyncMultiClient Client;

        NLog::TLogPtr Log;
        TStats& Stats;
    };
}
