EXECTEST()

OWNER(
    g:crypta
    g:crypta-cm
)

RUN(
    NAME testing_config
    CWD ${ARCADIA_ROOT}/crypta/cm/services/rt_duid_uploader/rt_cm_duid_uploader/bundle/templates

    render_and_check_yaml
    --template config.yaml
    --output ${TEST_CASE_ROOT}/output.yaml
    --context '{"environment": "testing", "dc": "man"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME stable_config
    CWD ${ARCADIA_ROOT}/crypta/cm/services/rt_duid_uploader/rt_cm_duid_uploader/bundle/templates

    render_and_check_yaml
    --template config.yaml
    --output ${TEST_CASE_ROOT}/output.yaml
    --context '{"environment": "production", "dc": "sas"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME testing_qa
    CWD ${ARCADIA_ROOT}/crypta/cm/services/rt_duid_uploader/rt_cm_duid_uploader/bundle/templates

    render_and_check_yaml
    --template config.yaml
    --output ${TEST_CASE_ROOT}/output.yaml
    --context '{"environment": "qa", "dc": "qa", "logbroker_server": "localhost", "logbroker_port": "20500", "topic": "lb-topic", "client_id": "lb-consumer", "client_tvm_id": "", "log_dir": "/tmp", "use_secure_tvm": false, "log_level": "trace", "sample_percent": 5}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)


RUN(
    NAME testing_factory_config
    CWD ${ARCADIA_ROOT}/crypta/cm/services/rt_duid_uploader/rt_cm_duid_uploader/bundle/templates

    render_and_check_yaml
    --template factory_config.yaml
    --output ${TEST_CASE_ROOT}/output.yaml
    --context '{"environment": "testing"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME stable_factory_config
    CWD ${ARCADIA_ROOT}/crypta/cm/services/rt_duid_uploader/rt_cm_duid_uploader/bundle/templates

    render_and_check_yaml
    --template factory_config.yaml
    --output ${TEST_CASE_ROOT}/output.yaml
    --context '{"environment": "production"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME testing_qa_factory_config
    CWD ${ARCADIA_ROOT}/crypta/cm/services/rt_duid_uploader/rt_cm_duid_uploader/bundle/templates

    render_and_check_yaml
    --template factory_config.yaml
    --output ${TEST_CASE_ROOT}/output.yaml
    --context '{"environment": "qa", "url": "post://localhost:1234/upload", "source_tvm_id": 1000501, "destination_tvm_id": 1000502}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

DATA(
    arcadia/crypta/cm/services/rt_duid_uploader/rt_cm_duid_uploader/bundle/templates/config.yaml
    arcadia/crypta/cm/services/rt_duid_uploader/rt_cm_duid_uploader/bundle/templates/factory_config.yaml
)

DEPENDS(
    crypta/utils/render_and_check_yaml
)

END()
