#include "cm_request_factory.h"

#include <crypta/cm/services/common/serializers/match/json/match_json_serializer.h>
#include <crypta/cm/services/common/data/id_utils.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/log/wrappers/tvm/tvm_spdlog_wrapper.h>
#include <crypta/lib/native/tvm/headers.h>
#include <crypta/lib/native/tvm/create_tvm_client.h>

#include <library/cpp/http/io/headers.h>
#include <library/cpp/neh/http_common.h>

#include <util/string/builder.h>

using namespace NCrypta;
using namespace NCrypta::NCm;
using namespace NCrypta::NCm::NRtDuidUploader;


TCmRequestFactory::TCmRequestFactory(const TCmRequestFactoryConfig& config)
    : Url(config.GetUrl())
    , TvmClient(CreateTvmClient(config.GetTvm()))
    , CmAlias(config.GetCmAlias())
{
}

NNeh::TMessage TCmRequestFactory::CreateRequest(const TMatch& match) const {
    auto cmMatch = ::NCrypta::NCm::TMatch(TId("duid", match.Duid));
    cmMatch.AddId(TMatchedId(TId("yandexuid", match.Yuid), TInstant::Zero(), 0, {{REALTIME_ATTRIBUTE, REALTIME_TRUE_STR}}));

    auto msg = NNeh::TMessage(Url, "");
    const auto& content = NCrypta::NCm::NMatchSerializer::ToJson(cmMatch);

    const auto& ticket = TvmClient.GetServiceTicketFor(CmAlias);

    THttpHeaders headers;
    headers.AddHeader(SERVICE_TICKET_HEADER, ticket);
    TStringStream serializedHeaders;
    headers.OutTo(&serializedHeaders);

    Y_ENSURE(NNeh::NHttp::MakeFullRequest(msg, serializedHeaders.Str(), content, "application/json"), "Failed to build message");

    return msg;
};
