import collections
import time

from crypta.cm.services.uploader.lib import errors
from crypta.lib.python.yt.http_mapper import tvm_http_requests_mapper


URL_TEMPLATE_UPLOAD = "/upload?subclient=uploader"


class UploadMatchMapper(tvm_http_requests_mapper.TvmHttpRequestsMapper):
    def __init__(self, max_retries, frozen_time, *args, **kwargs):
        super(UploadMatchMapper, self).__init__(*args, **kwargs)

        self.retry_counter = collections.Counter()
        self.max_retries = max_retries
        self.frozen_time = frozen_time
        self.batch_size = 1

    def get_request_wo_headers(self, batch):
        yield "POST", self.url, batch[0]["match"]

    def is_match_retriable(self, request):
        return (self.retry_counter[request.batch[0]["match"]] < self.max_retries) and (request.status != 400)

    def retry_failed_request(self, request):
        self.retry_counter.update([request.batch[0]["match"]])
        return self.is_match_retriable(request)

    def process_response(self, request):
        match = request.batch[0]["match"]

        if not request.ok and not self.is_match_retriable(request):
            yield {
                errors.MATCH: match,
                errors.STATUS: str(request.status),
                errors.DATA: request.response_body,
                errors.UNIXTIME: int(self.frozen_time or time.time()),
            }
        elif request.ok and match in self.retry_counter:
            del self.retry_counter[match]
