import argparse
import logging

from crypta.cm.tools.bin.dyn_tools.lib import (
    cmd_add_replica,
    cmd_disconnect_replica,
    cmd_list_replicas,
    cmd_remove_replica,
    cmd_replace_state,
    cmd_setup,
)
from crypta.lib.python.logging import logging_helpers


def parse_args():
    logging_helpers.configure_stdout_logger(logging.getLogger())
    parser = argparse.ArgumentParser()
    subparsers = parser.add_subparsers()

    cmd_add_replica.add_args_subparser(subparsers)
    cmd_disconnect_replica.add_args_subparser(subparsers)
    cmd_list_replicas.add_args_subparser(subparsers)
    cmd_remove_replica.add_args_subparser(subparsers)
    cmd_replace_state.add_args_subparser(subparsers)
    cmd_setup.add_args_subparser(subparsers)

    return parser.parse_args()


def main():
    args = parse_args()
    function = args.function
    function_args = dict(vars(args))
    del function_args["function"]
    return function(**function_args)
