from crypta.cm.tools.bin.dyn_tools.lib import helpers
from crypta.lib.python.yt import yt_helpers
from crypta.lib.python.yt.dyntable_utils import replica_utils


def add_args_subparser(subparsers):
    parser = subparsers.add_parser("list-replicas", description="List replicas")
    parser.set_defaults(function=main)

    helpers.add_config_args(parser)


def main(config):
    config = helpers.get_config(config)

    yt_token = helpers.get_robot_crypta_token(config["environment_type"])
    yt_client = yt_helpers.get_yt_client(helpers.get_master_cluster(config), yt_token=yt_token)

    replicas = replica_utils.list_replicas(yt_client, helpers.get_master_path(config))
    replica_utils.print_replicas(replicas)
