from crypta.cm.tools.bin.dyn_tools.lib import helpers
from crypta.lib.python.yt import yt_helpers
from crypta.lib.python.yt.dyntables.convert_to_kv import convert_to_kv
from crypta.lib.python.yt.dyntables.kv_master import KvMaster
from crypta.lib.python.yt.dyntables.kv_replica import KvReplica


def add_args_subparser(subparsers):
    parser = subparsers.add_parser("replace-state", description="Replace replica table")
    parser.set_defaults(function=main)

    helpers.add_config_args(parser)
    parser.add_argument("--cluster-name", required=True, help="Replica cluster name")
    parser.add_argument("--source-path", required=True, help="Source table path for state")


def main(config_path, cluster_name, source_path):
    config = helpers.get_config(config_path)

    if cluster_name not in config["replica"]["clusters"]:
        raise Exception("Cluster is not in the configuration")

    yt_token = helpers.get_token(config["token"]["path"])

    master_client = yt_helpers.get_yt_client("{}.yt.yandex.net".format(config["master"]["cluster"]), yt_token=yt_token)
    kv_master = KvMaster.from_existing(master_client, config["master"]["path"])

    replica_client = yt_helpers.get_yt_client("{}.yt.yandex.net".format(cluster_name), yt_token=yt_token)
    replica = KvReplica.from_existing(kv_master, replica_client, config["replica"]["path"])

    tmp_dir = config["replica"]["tmp_dir"]
    replica_client.create("map_node", tmp_dir, ignore_existing=True)
    with replica_client.TempTable(tmp_dir) as tmp_table:
        convert_to_kv(replica_client, source_path, tmp_table, kv_master.schema)
        replica.replace_with_static(tmp_table)
