from crypta.cm.tools.bin.dyn_tools.lib import helpers
from crypta.lib.python.yt import yt_helpers
from crypta.lib.python.yt.dyntables import kv_schema
from crypta.lib.python.yt.dyntables.kv_setup import kv_setup


def add_args_subparser(subparsers):
    parser = subparsers.add_parser("setup", description="Setup master and replicas")
    parser.set_defaults(function=main)

    helpers.add_config_args(parser)


def main(config_path):
    config = helpers.get_config(config_path)

    master_client = yt_helpers.get_yt_client("{}.yt.yandex.net".format(config["master"]["cluster"]), helpers.get_token(config["token"]["path"]))

    replica_clusters = [(name, helpers.create_yt_client("{}.yt.yandex.net".format(name))) for name in config["replica"]["clusters"]]

    kv_setup(
        master_client,
        replica_clusters,
        config["master"]["path"],
        config["replica"]["path"],
        kv_schema.get(),
        bundle=config["bundle"],
        pivot_keys=kv_schema.create_pivot_keys(config["tablets"]),
        sync=config["sync"],
        enable_tablet_balancer=config.get("enable_tablet_balancer", False),
        sync_replica_count=config.get("sync_replica_count"),
        enable_replicated_table_tracker=config.get("enable_replicated_table_tracker", False),
    )
