import functools

from crypta.cm.tools.bin.dyn_tools.lib import helpers
from crypta.lib.python.yt import yt_helpers
from crypta.lib.python.yt.dyntable_utils import replica_utils


ACTION_REMOVE = "remove"
ACTION_DISCONNECT = "disconnect"


def add_args_subparser(subparsers, cmd_name, description, action):
    assert action in [ACTION_REMOVE, ACTION_DISCONNECT]

    parser = subparsers.add_parser(cmd_name, description=description)
    parser.set_defaults(function=functools.partial(main, action=action))

    helpers.add_config_args(parser)

    helpers.add_cluster_args(parser, "--dc", "--replica-cluster")

    parser.add_argument("--replica-table", help="Path to non-default replica table")
    parser.add_argument("--dry-run", action="store_true", help="Only show prospective changes")


def main(
    action,
    config,
    dc,
    replica_cluster,
    replica_table,
    dry_run,
):
    config = helpers.get_config(config)

    master_cluster = helpers.get_master_cluster(config)
    master_path = helpers.get_master_path(config)

    replica_cluster = helpers.select_replica_cluster_name(dc, replica_cluster, config)
    replica_path = helpers.select_replica_path(replica_table, config)

    print(
        "Going to {action} replica:\n"
        "\tmaster cluster: {master_cluster}\n"
        "\tmaster path: {master_path}\n"
        "\treplica cluster: {replica_cluster}\n"
        "\treplica path: {replica_path}\n".format(
            action=action,
            master_cluster=master_cluster,
            master_path=master_path,
            replica_cluster=replica_cluster,
            replica_path=replica_path,
        )
    )

    if dry_run:
        print("NO CHANGES will be applied due to --dry-run")
        success = True
    else:
        yt_token = helpers.get_robot_crypta_token(config["environment_type"])

        master_yt_client = yt_helpers.get_yt_client(master_cluster, yt_token=yt_token)
        replica_yt_client = yt_helpers.get_yt_client(replica_cluster, yt_token=yt_token)

        action_function = replica_utils.remove_replica if action == ACTION_REMOVE else replica_utils.disconnect_replica

        success = action_function(
            master_yt_client,
            master_path,
            replica_yt_client,
            replica_path,
        )

    return 0 if success else 1
