import argparse
import logging

from crypta.cm.tools.bin.quoter_client.lib import cmd_get_quota_state
from crypta.lib.python.logging import logging_helpers


def parse_args():
    logging_helpers.configure_stdout_logger(logging.getLogger())
    parser = argparse.ArgumentParser()
    subparsers = parser.add_subparsers(dest="function")

    cmd_get_quota_state.add_args_subparser(subparsers)

    return parser.parse_args()


def main():
    args = parse_args()
    function = args.function
    function_args = dict(vars(args))
    del function_args["function"]
    return function(**function_args)
