import argparse

from crypta.cm.services.common import quoter_clients


def add_args_subparser(subparsers):
    parser = subparsers.add_parser(
        "get-quota-state",
        formatter_class=argparse.RawDescriptionHelpFormatter,
        description=(
            "Get quota state from quoter server\n"
            "Examples:\n"
            "  cm quoter-client get-quota-state --server <host:port> --cm-env production\n"
        )
    )

    parser.set_defaults(function=main)

    parser.add_argument("--host", default="quoter.cm.crypta.yandex.net")
    parser.add_argument("--port", default=80)
    parser.add_argument("--cm-env", help="production or testing", required=True)


def main(host, port, cm_env):
    client = quoter_clients.QuoterClient(host, port)

    state = client.get_quota_state(cm_env)

    print("IsFull: {}".format(state.IsFull))
    print("Description: {}".format(state.Description))

    return 0
